/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.circuit;

import com.cudos.circuit.CircuitComponent;
import com.cudos.circuit.Circuitboard;
import com.cudos.common.CudosExhibit;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Capacitor
extends CircuitComponent {
    static int sid = 0;
    int id;
    JTextField tcapacitance = new JTextField();
    JLabel jLabel1 = new JLabel();
    JSlider scapacitance = new JSlider();
    Border border1;
    double charge = 0.0;
    double capacitance;
    double tEMF = 0.0;
    JLabel jLabel2 = new JLabel();
    JTextField tcharge = new JTextField();
    JButton discharge = new JButton();

    public Capacitor(Circuitboard cb) {
        super(cb);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.id = sid++;
        this.cname.setText("Capacitor" + this.id);
        this.i = CudosExhibit.getApplet(this.getCircuitboard()).getImage("resources/icons/Capacitor.gif");
        this.scapacitance.setValue(30);
    }

    String getUnit() {
        return "F";
    }

    public int getBehaviour() {
        return 3;
    }

    public double getResistance() {
        return 1.0;
    }

    public double getResistanceFromEMF(double e) {
        this.tEMF += e;
        return this.getResistance();
    }

    public double getEMF() {
        return this.charge / this.capacitance;
    }

    public void process() {
        if (!Double.isNaN(this.current)) {
            double dQ = this.current * this.cb.deltat;
            double Vapplied = this.tEMF / 3.0 + this.getEMF();
            this.charge = ((this.charge + dQ) / this.capacitance - Vapplied) * (this.charge / this.capacitance - Vapplied) >= 0.0 ? (this.charge += dQ) : Vapplied * this.capacitance;
            this.chargeChange();
            this.tEMF = 0.0;
        }
    }

    public void chargeChange() {
        String r = this.unitString(this.charge);
        r = r.substring(0, r.length() - 1);
        this.tcharge.setText(String.valueOf(r) + "C");
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createLineBorder(SystemColor.control, 1);
        this.jLabel1.setText("Capacitance");
        this.jLabel1.setLabelFor(this.tcapacitance);
        this.tcapacitance.setPreferredSize(new Dimension(80, 21));
        this.tcapacitance.setText("100");
        this.setPreferredSize(new Dimension(200, 160));
        this.scapacitance.setMaximum(70);
        this.scapacitance.setPaintTicks(true);
        this.scapacitance.setPreferredSize(new Dimension(180, 24));
        this.scapacitance.setBorder(this.border1);
        this.scapacitance.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Capacitor.this.scapacitance_stateChanged(e);
            }
        });
        this.jLabel2.setText("Charge");
        this.tcharge.setPreferredSize(new Dimension(100, 21));
        this.tcharge.setText("0 C");
        this.discharge.setPreferredSize(new Dimension(170, 27));
        this.discharge.setText("Discharge now");
        this.discharge.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Capacitor.this.discharge_actionPerformed(e);
            }
        });
        this.add((Component)this.jLabel1, null);
        this.add((Component)this.tcapacitance, null);
        this.add((Component)this.scapacitance, null);
        this.add((Component)this.jLabel2, null);
        this.add((Component)this.tcharge, null);
        this.add((Component)this.discharge, null);
    }

    void scapacitance_stateChanged(ChangeEvent e) {
        int v = this.scapacitance.getValue();
        this.capacitance = 1.0E-9 * Math.pow(10.0, v / 10) * (double)(v % 10 + 1);
        this.tcapacitance.setText(this.unitString(this.capacitance));
    }

    void discharge_actionPerformed(ActionEvent e) {
        this.charge = 0.0;
        this.chargeChange();
    }

    public double getCapacitance() {
        return this.capacitance;
    }

    public void setCapacitance(double capacitance) {
        this.capacitance = capacitance;
        this.tcapacitance.setText(this.unitString(capacitance));
    }
}

