/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.circuit;

import com.cudos.circuit.CircuitComponent;
import com.cudos.circuit.Circuitboard;
import com.cudos.common.CudosExhibit;
import com.cudos.common.GraphableComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class Ammeter
extends CircuitComponent
implements GraphableComponent {
    static int sid = 0;
    int id;
    double maxDeflection = 0.05;
    double maxAngle = 1.1938052083641213;
    JLabel meter = new JLabel(){

        public void paint(Graphics g_) {
            super.paint(g_);
            Graphics2D g = (Graphics2D)g_;
            g.setColor(Color.black);
            int r = Ammeter.this.meter.getHeight() - 3;
            int mid = Ammeter.this.meter.getWidth() / 2;
            double angle = Ammeter.this.maxAngle * Ammeter.this.current / Ammeter.this.maxDeflection;
            if (angle > Ammeter.this.maxAngle) {
                angle = Ammeter.this.maxAngle;
            } else if (angle < -Ammeter.this.maxAngle) {
                angle = -Ammeter.this.maxAngle;
            }
            g.drawLine(mid, r, mid + (int)((double)r * Math.sin(angle)), (int)((double)r * (1.0 - Math.cos(angle))));
            g.drawString(Ammeter.this.unitString(-Ammeter.this.maxDeflection), 15, 75);
            g.drawString(Ammeter.this.unitString(Ammeter.this.maxDeflection), this.getWidth() - CudosExhibit.getApplet(this).getTextWidth(g, Ammeter.this.unitString(Ammeter.this.maxDeflection)) - 15, 75);
            g.drawString(Ammeter.this.unitString(0.0), (this.getWidth() - CudosExhibit.getApplet(this).getTextWidth(g, Ammeter.this.unitString(0.0))) / 2, 24);
        }
    };
    JTextField tcurrent = new JTextField();
    JLabel graphcolour = new JLabel();
    Border border1;
    Border border2;

    public Ammeter(Circuitboard c) {
        super(c);
        this.id = sid++;
        this.cname.setText("Ammeter" + this.id);
        this.i = CudosExhibit.getApplet(this.getCircuitboard()).getImage("resources/icons/Ammeter.gif");
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void process() {
        this.tcurrent.setText(this.unitString(this.current));
        this.repaint();
    }

    String getUnit() {
        return "A";
    }

    public Ammeter() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createBevelBorder(1, new Color(3, 3, 3), new Color(4, 4, 4), Color.black, Color.black);
        this.border2 = BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(134, 134, 134), new Color(93, 93, 93));
        this.meter.setIcon(new ImageIcon(CudosExhibit.getApplet(this.getCircuitboard()).getImage("resources/icons/Meter.gif")));
        this.setPreferredSize(new Dimension(205, 180));
        this.tcurrent.setPreferredSize(new Dimension(80, 21));
        this.tcurrent.setText("0 A");
        this.graphcolour.setBackground(Color.black);
        this.graphcolour.setFont(new Font("Dialog", 1, 12));
        this.graphcolour.setForeground(Color.red);
        this.graphcolour.setBorder(this.border2);
        this.graphcolour.setOpaque(true);
        this.graphcolour.setPreferredSize(new Dimension(85, 21));
        this.graphcolour.setHorizontalAlignment(0);
        this.graphcolour.setHorizontalTextPosition(0);
        this.graphcolour.setText("Graph colour");
        this.add((Component)this.meter, null);
        this.add((Component)this.tcurrent, null);
        this.add((Component)this.graphcolour, null);
    }

    public double getGraphableValue() {
        return this.current;
    }

    public double getGraphableMin() {
        return -this.maxDeflection;
    }

    public double getGraphableMax() {
        return this.maxDeflection;
    }

    public void setColour(Color gcol) {
        this.graphcolour.setForeground(gcol);
    }
}

