/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.circuit;

import com.cudos.circuit.CircuitComponent;
import com.cudos.circuit.Circuitboard;
import com.cudos.common.CudosExhibit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.SystemColor;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ACSource
extends CircuitComponent {
    static int sid;
    int id;
    JPanel jPanel1 = new JPanel();
    Border border1;
    JLabel jLabel1 = new JLabel();
    JSlider svoltage = new JSlider();
    JTextField tvoltage = new JTextField();
    JPanel jPanel2 = new JPanel();
    Border border2;
    JSlider sfrequency = new JSlider();
    JLabel jLabel2 = new JLabel();
    Border border3;
    JTextField tfrequency = new JTextField();
    Border border4;
    int ticks;
    double voltage;
    double amplitude;
    double pd;
    double frequency;
    Border border5;
    JLabel percentagebar = new JLabel(){

        public void paint(Graphics g) {
            super.paint(g);
            int w = this.getWidth() / 2;
            if (ACSource.this.amplitude >= 0.0) {
                g.setColor(Color.blue);
                g.fill3DRect(w, 2, (int)((double)(w - 2) * ACSource.this.amplitude), this.getHeight() - 4, true);
            } else {
                g.setColor(Color.red);
                int b = (int)(-ACSource.this.amplitude * (double)(w - 2));
                g.fill3DRect(2 + w - b, 2, b, this.getHeight() - 4, true);
            }
        }
    };

    public ACSource(Circuitboard c) {
        super(c);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.id = sid++;
        this.cname.setText("AC_Source" + this.id);
        this.i = CudosExhibit.getApplet(this.getCircuitboard()).getImage("resources/icons/ACSource.gif");
        this.svoltage.setValue(30);
        this.sfrequency.setValue(20);
    }

    public double getEMF() {
        this.pd = this.amplitude * this.voltage;
        return this.pd;
    }

    public void process() {
        ++this.ticks;
        this.amplitude = Math.sin(this.frequency * 2.0 * Math.PI * (double)this.ticks * this.cb.deltat);
        this.percentagebar.repaint();
    }

    public String getUnit() {
        return "V";
    }

    public int getBehaviour() {
        return 3;
    }

    private void jbInit() throws Exception {
        this.border3 = BorderFactory.createLineBorder(SystemColor.control, 1);
        this.border4 = BorderFactory.createLineBorder(SystemColor.control, 1);
        this.border5 = BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(134, 134, 134), new Color(93, 93, 93));
        this.jLabel2.setText("Frequency");
        this.sfrequency.setMaximum(50);
        this.sfrequency.setPreferredSize(new Dimension(120, 28));
        this.sfrequency.setBorder(this.border3);
        this.sfrequency.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ACSource.this.sfrequency_stateChanged(e);
            }
        });
        this.border2 = BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(134, 134, 134), new Color(93, 93, 93));
        this.svoltage.setPreferredSize(new Dimension(130, 28));
        this.svoltage.setBorder(this.border4);
        this.svoltage.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ACSource.this.svoltage_stateChanged(e);
            }
        });
        this.svoltage.setMaximum(50);
        this.border1 = BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(134, 134, 134), new Color(93, 93, 93));
        this.jPanel1.setBorder(this.border1);
        this.jPanel1.setPreferredSize(new Dimension(195, 70));
        this.jLabel1.setText("Voltage");
        this.tvoltage.setPreferredSize(new Dimension(80, 21));
        this.tvoltage.setText("0 V");
        this.jPanel2.setBorder(this.border2);
        this.jPanel2.setPreferredSize(new Dimension(195, 70));
        this.tfrequency.setText("0 Hz");
        this.tfrequency.setPreferredSize(new Dimension(80, 21));
        this.setPreferredSize(new Dimension(205, 215));
        this.percentagebar.setBorder(this.border5);
        this.percentagebar.setPreferredSize(new Dimension(190, 20));
        this.add((Component)this.jPanel1, null);
        this.jPanel1.add((Component)this.jLabel1, null);
        this.jPanel1.add((Component)this.svoltage, null);
        this.jPanel1.add((Component)this.tvoltage, null);
        this.add((Component)this.jPanel2, null);
        this.jPanel2.add((Component)this.jLabel2, null);
        this.jPanel2.add((Component)this.sfrequency, null);
        this.jPanel2.add((Component)this.tfrequency, null);
        this.add((Component)this.percentagebar, null);
    }

    void svoltage_stateChanged(ChangeEvent e) {
        int v = this.svoltage.getValue() - 1;
        this.voltage = v == 0 ? 0.0 : 0.001 * Math.pow(10.0, v / 10) * (double)(v % 10 + 1);
        this.tvoltage.setText(this.unitString(this.voltage));
    }

    void sfrequency_stateChanged(ChangeEvent e) {
        int f = this.sfrequency.getValue();
        this.frequency = Math.pow(10.0, f / 10) * (double)(f % 10 + 1);
        this.ticks = (int)(Math.asin(this.amplitude) / (Math.PI * 2 * this.frequency * this.cb.deltat));
        String ft = this.unitString(this.frequency);
        ft = ft.substring(0, ft.length() - 1);
        this.tfrequency.setText(String.valueOf(ft) + "Hz");
    }

    public void setVoltage(double voltage) {
        this.voltage = voltage;
        this.tvoltage.setText(this.unitString(voltage));
    }

    public double getVoltage() {
        return this.voltage;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public void setFrequency(double frequency) {
        this.frequency = frequency;
        String ft = this.unitString(frequency);
        ft = ft.substring(0, ft.length() - 1);
        this.tfrequency.setText(String.valueOf(ft) + "Hz");
    }
}

