/*
 * Decompiled with CFR 0.152.
 */
package com.cudos;

import com.cudos.common.CudosExhibit;
import com.cudos.common.kinetic.KineticPane;
import com.cudos.common.kinetic.Membrane;
import com.cudos.common.kinetic.Molecule;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TransportProcesses
extends CudosExhibit
implements ChangeListener {
    static final String[] comments = new String[]{"Since the membrane is sugar-impermeable, water molecules that are bound to sugar molecules (by hydrogen bonding) are not free to diffuse across the membrane. So there is less diffusion out from the more concentrated solution, giving a net flux of water in.", "The membrane is partially permeable to water molecules, and so when the concentrations of molecules either side of the membrane are equal, the rates of movement in either direction across the membrane are equal. This gives a state of dynamic equilibrium.", "The membrane molecules act like channels which allow specific types of molecule to pass through freely.", "", "The transporter proteins use ATP to pump molecules across the membrane. They operate in one direction only, consume energy and are capable of pumping against (i.e. up) a concentration gradient.", "3 Na+ ions are expelled, and 2 K+ ions are pumped in, using energy from the breakdown of ATP. The pump is ubiquitous, unidirectional, and is responsible for maintaining the normal electrochemical gradient across the membrane of the cell."};
    JPanel main = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JButton jButton1 = new JButton();
    Border border1;
    JPanel jPanel2 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    Border border2;
    JPanel jPanel3 = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    JTextPane textpane = new JTextPane();
    BorderLayout borderLayout4 = new BorderLayout();
    Border border3;
    JPanel graphicpane = new JPanel();
    Border border4;
    KineticPane kineticPane = new KineticPane();
    BorderLayout borderLayout5 = new BorderLayout();
    JPanel jPanel4 = new JPanel();
    Border border5;
    BorderLayout borderLayout6 = new BorderLayout();
    JPanel jPanel5 = new JPanel();
    BorderLayout borderLayout7 = new BorderLayout();
    JPanel jPanel6 = new JPanel();
    JSlider temperature = new JSlider();
    JLabel jLabel1 = new JLabel();
    JPanel jPanel7 = new JPanel();
    JRadioButton primary = new JRadioButton();
    JRadioButton secondary = new JRadioButton();
    Border border6;
    TitledBorder titledBorder1;
    JPanel jPanel8 = new JPanel();
    JRadioButton diffusion = new JRadioButton();
    JRadioButton osmosis = new JRadioButton();
    Border border7;
    TitledBorder titledBorder2;
    GridLayout gridLayout1 = new GridLayout();
    FlowLayout flowLayout1 = new FlowLayout();
    FlowLayout flowLayout2 = new FlowLayout();
    JRadioButton facilitated = new JRadioButton();
    Timer timer;
    int memy;
    int[] nmols = new int[7];
    Random rand = new Random();
    Membrane membrane;
    int[] slidertype;
    ButtonGroup bg1;
    JSlider[] slider;
    JLabel[] sliderlabel;
    JPanel[] sliderpanel;
    Border border8;
    JPanel jPanel9;
    Border border9;
    TitledBorder titledBorder3;
    GridLayout gridLayout2;
    BorderLayout borderLayout8;
    BorderLayout borderLayout9;
    BorderLayout borderLayout10;
    JSlider sugarsize;
    JLabel jLabel2;
    Border border10;
    JRadioButton sodiumpump;

    public String getExhibitName() {
        return "Transport Processes";
    }

    public TransportProcesses() {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        this.slidertype = nArray;
        this.bg1 = new ButtonGroup();
        this.slider = new JSlider[4];
        this.sliderlabel = new JLabel[4];
        this.sliderpanel = new JPanel[4];
        this.jPanel9 = new JPanel();
        this.gridLayout2 = new GridLayout();
        this.borderLayout8 = new BorderLayout();
        this.borderLayout9 = new BorderLayout();
        this.borderLayout10 = new BorderLayout();
        this.sugarsize = new JSlider();
        this.jLabel2 = new JLabel();
        this.sodiumpump = new JRadioButton();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void postinit() {
        this.nmols[0] = 100;
        this.nmols[1] = 0;
        this.nmols[2] = 0;
        this.memy = (this.kineticPane.getHeight() - Membrane.thickness) / 2;
        this.membrane = this.kineticPane.createMembraneAcross(this.memy, 0, this.kineticPane.getWidth());
        Rectangle b = new Rectangle(5, 5, this.kineticPane.getWidth() - 5, this.memy - 20);
        int k = 0;
        while (k < 2) {
            int j = 0;
            while (j < this.nmols[k]) {
                Molecule m = new Molecule(this.rand, b);
                this.kineticPane.molecules.add(m);
                m.setType(k);
                ++j;
            }
            ++k;
        }
        this.timer = new Timer(250, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TransportProcesses.this.setSliders();
            }
        });
        this.osmosis.doClick();
        this.timer.start();
    }

    void transportchange(ActionEvent e) {
        if (this.osmosis.isSelected()) {
            this.removeSpecificMolecules();
            this.nmols[1] = 100;
            Rectangle b = new Rectangle(5, 5, this.kineticPane.getWidth() - 5, this.memy - 20);
            int j = 0;
            while (j < this.nmols[1]) {
                Molecule m = new Molecule(this.rand, b);
                this.kineticPane.molecules.add(m);
                m.setType(1);
                ++j;
            }
            this.textpane.setText(comments[0]);
            this.setupSliders(0, 1, 2);
        } else if (this.primary.isSelected()) {
            Class<?> pumpclass;
            this.removeSpecificMolecules();
            try {
                pumpclass = Class.forName("com.cudos.common.kinetic.SimplePump");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
            this.kineticPane.createTransporter(pumpclass, this.membrane, 60, 20);
            this.kineticPane.createTransporter(pumpclass, this.membrane, 160, 20);
            this.kineticPane.createTransporter(pumpclass, this.membrane, 260, 20);
            this.kineticPane.createTransporter(pumpclass, this.membrane, 360, 20);
            Rectangle b = new Rectangle(5, 5, this.kineticPane.getWidth() - 5, this.memy - 20);
            this.nmols[1] = 100;
            int j = 0;
            while (j < this.nmols[1]) {
                Molecule m = new Molecule(this.rand, b);
                this.kineticPane.molecules.add(m);
                m.setType(1);
                ++j;
            }
            this.textpane.setText(comments[4]);
            this.setupSliders(0, 1, 2);
        } else if (this.diffusion.isSelected()) {
            this.removeSpecificMolecules();
            this.textpane.setText(comments[1]);
            this.setupSliders(0, 1, 2);
        } else if (this.facilitated.isSelected()) {
            Class<?> diffclass;
            this.removeSpecificMolecules();
            try {
                diffclass = Class.forName("com.cudos.common.kinetic.DiffusionChannel");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
            this.kineticPane.createTransporter(diffclass, this.membrane, 100, 20);
            this.kineticPane.createTransporter(diffclass, this.membrane, 200, 20);
            this.kineticPane.createTransporter(diffclass, this.membrane, 300, 20);
            this.textpane.setText(comments[2]);
            Rectangle b = new Rectangle(5, 5, this.kineticPane.getWidth() - 5, this.memy - 20);
            this.nmols[1] = 100;
            int j = 0;
            while (j < this.nmols[1]) {
                Molecule m = new Molecule(this.rand, b);
                this.kineticPane.molecules.add(m);
                m.setType(1);
                ++j;
            }
            this.setupSliders(0, 1, 2);
        } else if (this.sodiumpump.isSelected()) {
            Molecule m;
            Class<?> pumpclass;
            this.removeSpecificMolecules();
            try {
                pumpclass = Class.forName("com.cudos.common.kinetic.SodiumPump");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
            this.kineticPane.createTransporter(pumpclass, this.membrane, 100, 20);
            this.kineticPane.createTransporter(pumpclass, this.membrane, 200, 20);
            this.kineticPane.createTransporter(pumpclass, this.membrane, 300, 20);
            this.kineticPane.createTransporter(pumpclass, this.membrane, 400, 20);
            Rectangle b = new Rectangle(5, 5, this.kineticPane.getWidth() - 5, this.memy - 20);
            this.nmols[2] = 50;
            this.nmols[3] = 50;
            int j = 0;
            while (j < this.nmols[2]) {
                m = new Molecule(this.rand, b);
                this.kineticPane.molecules.add(m);
                m.setType(2);
                ++j;
            }
            j = 0;
            while (j < this.nmols[3]) {
                m = new Molecule(this.rand, b);
                this.kineticPane.molecules.add(m);
                m.setType(3);
                ++j;
            }
            this.textpane.setText(comments[5]);
            this.setupSliders(0, 2, 3);
        } else if (this.secondary.isSelected()) {
            Molecule m;
            Class<?> transclass;
            Class<?> pumpclass;
            this.removeSpecificMolecules();
            try {
                pumpclass = Class.forName("com.cudos.common.kinetic.SodiumPump");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
            try {
                transclass = Class.forName("com.cudos.common.kinetic.Antiporter");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
            this.kineticPane.createTransporter(pumpclass, this.membrane, 100, 20);
            this.kineticPane.createTransporter(transclass, this.membrane, 200, 20);
            this.kineticPane.createTransporter(transclass, this.membrane, 300, 20);
            this.kineticPane.createTransporter(pumpclass, this.membrane, 400, 20);
            Rectangle b = new Rectangle(5, 5, this.kineticPane.getWidth() - 5, this.memy - 20);
            this.nmols[2] = 50;
            this.nmols[3] = 50;
            this.nmols[1] = 50;
            int j = 0;
            while (j < this.nmols[2]) {
                m = new Molecule(this.rand, b);
                this.kineticPane.molecules.add(m);
                m.setType(2);
                ++j;
            }
            j = 0;
            while (j < this.nmols[3]) {
                m = new Molecule(this.rand, b);
                this.kineticPane.molecules.add(m);
                m.setType(3);
                ++j;
            }
            j = 0;
            while (j < this.nmols[1]) {
                m = new Molecule(this.rand, b);
                this.kineticPane.molecules.add(m);
                m.setType(1);
                ++j;
            }
            this.textpane.setText(comments[5]);
            this.setupSliders(1, 2, 3);
        }
        this.kineticPane.repaint();
        this.textpane.repaint();
    }

    public void removeSpecificMolecules() {
        this.kineticPane.removeMolecules(4);
        this.kineticPane.removeMolecules(1);
        this.kineticPane.removeMolecules(2);
        this.kineticPane.removeMolecules(3);
        this.nmols[2] = 0;
        this.nmols[3] = 0;
        this.nmols[1] = 0;
    }

    public void setupSliders(int a, int b, int c) {
        this.slidertype = new int[]{a, b, c};
        int i = 0;
        while (i < 3) {
            this.sliderlabel[i + 1].setText(Molecule.names[this.slidertype[i]]);
            ++i;
        }
        this.setSliders();
    }

    public void setSliders() {
        int i = 1;
        while (i < 4) {
            int type = this.slidertype[i - 1];
            if (this.nmols[type] > 0) {
                this.slider[i].setValue(100 * this.kineticPane.getMoleculesAbove(this.memy, type) / this.nmols[type]);
            } else {
                this.slider[i].setValue(0);
            }
            ++i;
        }
    }

    public void stateChanged(ChangeEvent s) {
        block8: {
            int tries;
            Random r;
            int ht;
            int midline;
            Graphics2D g;
            int needm;
            int currm;
            int i;
            block9: {
                JSlider sl = (JSlider)s.getSource();
                i = 3;
                int j = 0;
                while (j < 3) {
                    if (this.slider[j + 1] == sl) {
                        i = j;
                        break;
                    }
                    ++j;
                }
                if (i == 3) {
                    throw new RuntimeException("Cannot find slider");
                }
                currm = this.kineticPane.getMoleculesAbove(this.memy, i = this.slidertype[i]);
                if (currm == (needm = this.nmols[i] * sl.getValue() / 100)) break block8;
                g = (Graphics2D)this.kineticPane.getGraphics();
                midline = this.memy + Membrane.thickness / 2;
                ht = this.kineticPane.getHeight();
                r = new Random();
                tries = 0;
                if (currm <= needm) break block9;
                while (this.kineticPane.getMoleculesAbove(this.memy, i) > needm && ++tries < 20) {
                    Molecule m = this.kineticPane.getAMolecule(r, i);
                    if (m == null || m.y >= midline) continue;
                    int ny = ht - m.y;
                    while (ny < this.memy + Membrane.thickness + 10) {
                        ny += m.s;
                    }
                    m.move(g, m.x, ny);
                }
                break block8;
            }
            if (currm >= needm) break block8;
            while (this.kineticPane.getMoleculesAbove(this.memy, i) < needm && ++tries < 20) {
                Molecule m = this.kineticPane.getAMolecule(r, i);
                if (m == null || m.y <= midline) continue;
                int ny = ht - m.y - m.s;
                if (ny < 0) {
                    ny = 0;
                }
                while (ny > this.memy) {
                    ny -= m.s;
                }
                m.move(g, m.x, ny);
            }
        }
    }

    private void jbInit() throws Exception {
        this.sliderpanel[3] = new JPanel();
        this.sliderpanel[2] = new JPanel();
        this.sliderlabel[2] = new JLabel();
        this.sliderlabel[3] = new JLabel();
        this.slider[2] = new JSlider();
        this.slider[3] = new JSlider();
        this.sliderpanel[1] = new JPanel();
        this.sliderlabel[1] = new JLabel();
        this.slider[1] = new JSlider();
        this.border1 = new EtchedBorder(0, Color.white, new Color(134, 134, 134));
        this.border2 = new EtchedBorder(0, Color.white, new Color(134, 134, 134));
        this.border3 = new EtchedBorder(0, Color.white, new Color(134, 134, 134));
        this.border4 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.border5 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(93, 93, 93), new Color(134, 134, 134)), BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.border6 = BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134));
        this.titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), "Active transport");
        this.border7 = BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134));
        this.titledBorder2 = new TitledBorder(this.border7, "Passive transport");
        this.border8 = BorderFactory.createLineBorder(Color.lightGray, 1);
        this.border9 = BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134));
        this.titledBorder3 = new TitledBorder(this.border9, "Ratio");
        this.border10 = BorderFactory.createLineBorder(Color.lightGray, 1);
        this.jButton1.setText("Exit");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TransportProcesses.this.jButton1_actionPerformed(e);
            }
        });
        this.main.setLayout(this.borderLayout1);
        this.jPanel2.setLayout(this.borderLayout2);
        this.getContentPane().setLayout(this.borderLayout3);
        this.textpane.setPreferredSize(new Dimension(74, 100));
        this.textpane.setBackground(SystemColor.control);
        this.textpane.setBorder(this.border3);
        this.textpane.setText("jTextPane1");
        this.textpane.setFont(new Font("SansSerif", 1, 14));
        this.jPanel3.setLayout(this.borderLayout4);
        this.graphicpane.setBorder(this.border4);
        this.graphicpane.setLayout(this.borderLayout5);
        this.kineticPane.setBackground(new Color(192, 224, 224));
        this.kineticPane.setPreferredSize(new Dimension(100, 100));
        this.kineticPane.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TransportProcesses.this.kineticPane_mouseClicked(e);
            }
        });
        this.jPanel4.setBorder(this.border5);
        this.jPanel4.setLayout(this.borderLayout6);
        this.jPanel1.setLayout(this.borderLayout7);
        this.jPanel5.setLayout(this.gridLayout1);
        this.jPanel5.setPreferredSize(new Dimension(140, 1));
        this.jPanel6.setLayout(null);
        this.temperature.setBorder(this.border8);
        this.temperature.setBounds(new Rectangle(1, 2, 131, 24));
        this.temperature.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                TransportProcesses.this.temperaturechanged(e);
            }
        });
        this.jPanel6.setPreferredSize(new Dimension(1, 40));
        this.jLabel1.setText("Temperature");
        this.jLabel1.setBounds(new Rectangle(30, 23, 79, 17));
        this.primary.setText("Primary");
        this.primary.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TransportProcesses.this.transportchange(e);
            }
        });
        this.secondary.setToolTipText("");
        this.secondary.setText("Secondary");
        this.secondary.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TransportProcesses.this.transportchange(e);
            }
        });
        this.jPanel7.setBorder(this.titledBorder1);
        this.jPanel7.setMinimumSize(new Dimension(130, 63));
        this.jPanel7.setPreferredSize(new Dimension(130, 63));
        this.jPanel7.setLayout(this.flowLayout1);
        this.diffusion.setText("Diffusion");
        this.diffusion.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TransportProcesses.this.transportchange(e);
            }
        });
        this.osmosis.setText("Osmosis");
        this.osmosis.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TransportProcesses.this.transportchange(e);
            }
        });
        this.jPanel8.setBorder(this.titledBorder2);
        this.jPanel8.setPreferredSize(new Dimension(130, 63));
        this.jPanel8.setLayout(this.flowLayout2);
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setRows(3);
        this.flowLayout1.setAlignment(0);
        this.flowLayout2.setAlignment(0);
        this.facilitated.setOpaque(false);
        this.facilitated.setText("Facilitated diffusion");
        this.facilitated.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TransportProcesses.this.transportchange(e);
            }
        });
        this.jPanel9.setBorder(this.titledBorder3);
        this.jPanel9.setLayout(this.gridLayout2);
        this.sliderpanel[2].setLayout(this.borderLayout8);
        this.sliderpanel[3].setLayout(this.borderLayout9);
        this.sliderlabel[2].setText("Sugar");
        this.sliderlabel[3].setText("Na");
        this.slider[2].setOrientation(1);
        this.slider[3].setOrientation(1);
        this.sliderpanel[1].setLayout(this.borderLayout10);
        this.sliderlabel[1].setText("Water");
        this.slider[1].setOrientation(1);
        this.sugarsize.setBorder(this.border10);
        this.sugarsize.setBounds(new Rectangle(135, 2, 140, 25));
        this.sugarsize.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                TransportProcesses.this.sugarsizechanged(e);
            }
        });
        this.jLabel2.setText("Sugar size");
        this.jLabel2.setBounds(new Rectangle(176, 25, 60, 17));
        this.sodiumpump.setText("Na/K pump");
        this.sodiumpump.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TransportProcesses.this.transportchange(e);
            }
        });
        this.getContentPane().add((Component)this.main, "Center");
        this.main.add((Component)this.jPanel1, "East");
        this.jPanel1.add((Component)this.jButton1, "South");
        this.jPanel1.add((Component)this.jPanel5, "Center");
        this.jPanel5.add((Component)this.jPanel8, null);
        this.jPanel8.add((Component)this.osmosis, null);
        this.jPanel8.add((Component)this.diffusion, null);
        this.jPanel8.add((Component)this.facilitated, null);
        this.jPanel5.add((Component)this.jPanel7, null);
        this.jPanel7.add((Component)this.secondary, null);
        this.jPanel7.add((Component)this.primary, null);
        this.jPanel7.add((Component)this.sodiumpump, null);
        this.jPanel5.add((Component)this.jPanel9, null);
        this.jPanel9.add((Component)this.sliderpanel[1], null);
        this.sliderpanel[1].add((Component)this.sliderlabel[1], "South");
        this.sliderpanel[1].add((Component)this.slider[1], "Center");
        this.jPanel9.add((Component)this.sliderpanel[2], null);
        this.sliderpanel[2].add((Component)this.sliderlabel[2], "South");
        this.sliderpanel[2].add((Component)this.slider[2], "Center");
        this.jPanel9.add((Component)this.sliderpanel[3], null);
        this.sliderpanel[3].add((Component)this.sliderlabel[3], "South");
        this.sliderpanel[3].add((Component)this.slider[3], "Center");
        this.main.add((Component)this.jPanel2, "Center");
        this.jPanel2.add((Component)this.jPanel3, "Center");
        this.jPanel3.add((Component)this.textpane, "South");
        this.jPanel3.add((Component)this.graphicpane, "Center");
        this.graphicpane.add((Component)this.jPanel4, "Center");
        this.jPanel4.add((Component)this.kineticPane, "Center");
        this.graphicpane.add((Component)this.jPanel6, "South");
        this.jPanel6.add((Component)this.temperature, null);
        this.jPanel6.add((Component)this.jLabel1, null);
        this.jPanel6.add((Component)this.sugarsize, null);
        this.jPanel6.add((Component)this.jLabel2, null);
        int i = 0;
        while (i < 3) {
            this.slider[i + 1].addChangeListener(this);
            ++i;
        }
        this.bg1.add(this.facilitated);
        this.bg1.add(this.diffusion);
        this.bg1.add(this.osmosis);
        this.bg1.add(this.primary);
        this.bg1.add(this.secondary);
        this.bg1.add(this.sodiumpump);
    }

    void jButton1_actionPerformed(ActionEvent e) {
        this.timer.stop();
        this.getApplet().toChooser();
    }

    void temperaturechanged(ChangeEvent e) {
        this.kineticPane.timer.setDelay(200 - this.temperature.getValue() * 2);
    }

    void sugarsizechanged(ChangeEvent e) {
        this.kineticPane.setMoleculeSizes(1, this.sugarsize.getValue() / 4);
    }

    void kineticPane_mouseClicked(MouseEvent e) {
        this.kineticPane.repaint();
    }
}

