/*
 * Decompiled with CFR 0.152.
 */
package com.cudos;

import com.cudos.common.CudosExhibit;
import com.cudos.common.Oscilloscope;
import com.cudos.common.SelectionRecipient;
import com.cudos.mechanics.BaseComponent;
import com.cudos.mechanics.Dashpot;
import com.cudos.mechanics.MechanicsComponent;
import com.cudos.mechanics.MechanicsData;
import com.cudos.mechanics.MechanicsDisplay;
import com.cudos.mechanics.Node;
import com.cudos.mechanics.Spring;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.Timer;
import javax.swing.border.EtchedBorder;
import javax.swing.filechooser.FileFilter;

public class SpringMechanics
extends CudosExhibit
implements SelectionRecipient {
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel3 = new JPanel();
    JPopupMenu addpopup = new JPopupMenu();
    JMenuItem adddashpot = new JMenuItem();
    JMenuItem addspring = new JMenuItem();
    Oscilloscope oscilloscope = new Oscilloscope();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel propertiesPanel = new JPanel();
    MechanicsDisplay display = new MechanicsDisplay();
    BorderLayout borderLayout3 = new BorderLayout();
    BorderLayout borderLayout4 = new BorderLayout();
    JPanel buttonsPane = new JPanel();
    JToggleButton addbutton = new JToggleButton();
    JButton removebutton = new JButton();
    JToggleButton joinbutton = new JToggleButton();
    BorderLayout borderLayout5 = new BorderLayout();
    JPanel controlPane = new JPanel();
    JToggleButton playbutton = new JToggleButton();
    JToggleButton pausebutton = new JToggleButton();
    JButton stopbutton = new JButton();
    JPanel jPanel6 = new JPanel();
    JButton filebutton = new JButton();
    JButton jButton2 = new JButton();
    JPopupMenu fileMenu = new JPopupMenu();
    JMenuItem jMenuItem1 = new JMenuItem();
    JMenuItem jMenuItem2 = new JMenuItem();
    JMenuItem jMenuItem3 = new JMenuItem();
    JMenuItem jMenuItem4 = new JMenuItem();
    JTextArea instructions = new JTextArea();
    public static final int SPRING = 1;
    public static final int DASHPOT = 2;
    boolean adding;
    boolean joiningfrom;
    boolean joiningto;
    boolean paused;
    int addCommand;
    Node joinFrom;
    BaseComponent selected;
    Timer timer = new Timer(100, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            SpringMechanics.this.tick();
        }
    });
    String currentFile = "";
    FileFilter mechfilefilter = new FileFilter(){

        public boolean accept(File f) {
            return f.getName().endsWith(".mec");
        }

        public String getDescription() {
            return "Mechanics file (*.mec)";
        }
    };

    public String getExhibitName() {
        return "Mechanics";
    }

    public SpringMechanics() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.borderLayout1);
        this.adddashpot.setText("Dashpot");
        this.adddashpot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SpringMechanics.this.handleAction(e);
            }
        });
        this.addspring.setText("Spring");
        this.addspring.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SpringMechanics.this.handleAction(e);
            }
        });
        this.jPanel1.setLayout(this.borderLayout2);
        this.oscilloscope.setPreferredSize(new Dimension(150, 150));
        this.oscilloscope.setGutter(3);
        this.jPanel2.setLayout(this.borderLayout3);
        this.display.setToolTipText("");
        this.propertiesPanel.setLayout(this.borderLayout4);
        this.addbutton.setText("Add");
        this.addbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SpringMechanics.this.handleAction(e);
            }
        });
        this.removebutton.setText("Remove");
        this.removebutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SpringMechanics.this.handleAction(e);
            }
        });
        this.joinbutton.setText("Join");
        this.joinbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SpringMechanics.this.handleAction(e);
            }
        });
        this.buttonsPane.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel3.setLayout(this.borderLayout5);
        this.playbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SpringMechanics.this.handleAction(e);
            }
        });
        this.pausebutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SpringMechanics.this.handleAction(e);
            }
        });
        this.stopbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SpringMechanics.this.handleAction(e);
            }
        });
        this.playbutton.setActionCommand("Play");
        this.pausebutton.setActionCommand("Pause");
        this.stopbutton.setActionCommand("Stop");
        this.propertiesPanel.setPreferredSize(new Dimension(200, 20));
        this.filebutton.setText("File");
        this.filebutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SpringMechanics.this.handleAction(e);
            }
        });
        this.jButton2.setText("Options");
        this.jMenuItem1.setActionCommand("Open");
        this.jMenuItem1.setText("Open");
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SpringMechanics.this.handleAction(e);
            }
        });
        this.jMenuItem2.setText("Save as");
        this.jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SpringMechanics.this.handleAction(e);
            }
        });
        this.jMenuItem3.setText("New");
        this.jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SpringMechanics.this.handleAction(e);
            }
        });
        this.jMenuItem4.setText("Exit");
        this.jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SpringMechanics.this.handleAction(e);
            }
        });
        this.getContentPane().add((Component)this.jPanel1, "East");
        this.jPanel1.add((Component)this.jPanel3, "North");
        this.jPanel3.add((Component)this.buttonsPane, "Center");
        this.buttonsPane.add((Component)this.addbutton, null);
        this.buttonsPane.add((Component)this.removebutton, null);
        this.buttonsPane.add((Component)this.joinbutton, null);
        this.jPanel3.add((Component)this.controlPane, "South");
        this.controlPane.add((Component)this.playbutton, null);
        this.controlPane.add((Component)this.pausebutton, null);
        this.controlPane.add((Component)this.stopbutton, null);
        this.jPanel1.add((Component)this.oscilloscope, "South");
        this.jPanel1.add((Component)this.propertiesPanel, "Center");
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.jPanel2.add((Component)this.display, "Center");
        this.jPanel2.add((Component)this.jPanel6, "North");
        this.jPanel6.add((Component)this.filebutton, null);
        this.jPanel6.add((Component)this.jButton2, null);
        this.addpopup.add(this.addspring);
        this.addpopup.add(this.adddashpot);
        this.fileMenu.add(this.jMenuItem1);
        this.fileMenu.add(this.jMenuItem2);
        this.fileMenu.add(this.jMenuItem3);
        this.fileMenu.add(this.jMenuItem4);
        this.jPanel3.add((Component)this.instructions, "North");
        this.instructions.setText("Select or move a node with the mouse, and use 'add' to add a spring or dashpot. Click on an element or a node to edit its properties.");
        this.instructions.setLineWrap(true);
        this.instructions.setWrapStyleWord(true);
        this.instructions.setEditable(false);
        this.instructions.setOpaque(false);
        this.instructions.setBorder(new EtchedBorder(1));
        this.instructions.setFont(this.getFont());
    }

    public void addNotify() {
        super.addNotify();
        this.init();
    }

    void handleAction(ActionEvent e) {
        String s = e.getActionCommand();
        if (s.equals("Remove")) {
            if (this.getSelected() != null) {
                this.display.getData().remove(this.display.getSelected());
                this.repaint();
            }
        } else if (s.equals("Add")) {
            this.joinbutton.setSelected(false);
            this.adding = false;
            if (this.addbutton.isSelected()) {
                this.addpopup.show(this.addbutton, 0, this.addbutton.getHeight());
            }
        } else if (s.equals("Spring")) {
            this.adding = true;
            this.addCommand = 1;
            if (this.getSelected() instanceof Node) {
                this.setSelected(this.getSelected());
            }
        } else if (s.equals("Dashpot")) {
            this.adding = true;
            this.addCommand = 2;
            if (this.getSelected() instanceof Node) {
                this.setSelected(this.getSelected());
            }
        } else if (s.equals("Join")) {
            this.addbutton.setSelected(false);
            if (this.joinbutton.isSelected()) {
                this.joiningfrom = true;
                this.joiningto = false;
                if (this.getSelected() instanceof Node) {
                    this.setSelected(this.getSelected());
                }
            } else {
                this.joiningfrom = false;
                this.joiningto = false;
            }
        } else if (s.equals("Play")) {
            if (!this.playbutton.isSelected()) {
                this.timer.stop();
            } else if (this.pausebutton.isSelected()) {
                this.tick();
                this.playbutton.setSelected(false);
            } else {
                this.timer.start();
                this.pausebutton.setSelected(false);
            }
        } else if (s.equals("Pause")) {
            if (this.pausebutton.isSelected()) {
                if (this.playbutton.isSelected()) {
                    this.timer.stop();
                    this.playbutton.setSelected(false);
                } else {
                    this.pausebutton.setSelected(false);
                }
            } else {
                this.playbutton.setSelected(true);
                this.timer.start();
            }
        } else if (s.equals("Stop")) {
            this.pausebutton.setSelected(false);
            this.playbutton.setSelected(false);
            this.timer.stop();
        } else if (s.equals("Save as")) {
            this.saveas();
        } else if (s.equals("Open")) {
            this.open();
        } else if (s.equals("New")) {
            this.newfile();
        } else if (s.equals("File")) {
            this.fileMenu.show(this.filebutton, 0, this.filebutton.getHeight());
        } else if (s.equals("Exit")) {
            this.timer.stop();
            this.getApplet().toChooser();
        }
    }

    public void setSelected(Object o) {
        this.propertiesPanel.removeAll();
        this.selected = (BaseComponent)o;
        if (this.selected != null) {
            this.propertiesPanel.add(this.selected.getPanel());
        }
        this.validateTree();
        this.propertiesPanel.repaint();
        if (this.adding && o instanceof Node) {
            MechanicsComponent a;
            Node top = (Node)o;
            if (this.addCommand == 1) {
                a = new Spring();
            } else if (this.addCommand == 2) {
                a = new Dashpot();
            } else {
                return;
            }
            a.setTop(top);
            Node bottom = new Node();
            bottom.x = a.x = top.x;
            bottom.y = top.y + a.getNaturalLength();
            a.setBottom(bottom);
            this.display.getData().add(bottom);
            this.display.getData().add(a);
            this.adding = false;
            this.addbutton.setSelected(false);
            this.display.repaint();
            return;
        }
        if (this.joiningfrom && o instanceof Node) {
            this.joinFrom = (Node)o;
            this.joiningfrom = false;
            this.joiningto = true;
            return;
        }
        if (this.joiningto && o instanceof Node) {
            Node joinTo = (Node)o;
            this.display.getData().joinNodes(this.joinFrom, joinTo);
            this.joiningto = false;
            this.joiningfrom = false;
            this.joinbutton.setSelected(false);
            this.setSelected(this.joinFrom);
            this.display.repaint();
            return;
        }
    }

    public Object getSelected() {
        return this.selected;
    }

    void init() {
        this.playbutton.setIcon(new ImageIcon(this.getApplet().getImage("resources/icons/Play.gif")));
        this.pausebutton.setIcon(new ImageIcon(this.getApplet().getImage("resources/icons/Pause.gif")));
        this.stopbutton.setIcon(new ImageIcon(this.getApplet().getImage("resources/icons/Stop.gif")));
        this.display.setSelectionRecipient(this);
        MechanicsData d = new MechanicsData();
        this.display.setData(new MechanicsData());
        d.getRoot().x = this.display.getWidth() / 2;
    }

    void tick() {
        MechanicsData data = this.display.getData();
        data.tick();
        Node[] n = data.getNodes();
        int[] npos = new int[n.length];
        int i = 0;
        while (i < n.length) {
            npos[i] = (int)(n[i].y * 3.0);
            ++i;
        }
        if (this.oscilloscope.graph.getNTraces() != npos.length) {
            this.oscilloscope.setNTraces(npos.length);
        }
        this.oscilloscope.setPosY(npos);
        this.display.repaint();
    }

    void open() {
    }

    void saveas() {
    }

    void save() {
        if (this.getCurrentFile() == "") {
            this.saveas();
        } else {
            this.save(this.getCurrentFile());
        }
    }

    void save(String filename) {
        try {
            new ObjectOutputStream(new FileOutputStream(filename)).writeObject(this.display.getData());
            this.setCurrentFile(filename);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e, "Save error", 0);
        }
    }

    void newfile() {
        if (!this.askClear()) {
            return;
        }
        this.display.getData().clearAll();
        this.display.repaint();
    }

    boolean askClear() {
        return JOptionPane.showConfirmDialog(this, "This will erase the current setup", "Clear current setup", 2) == 0;
    }

    String getCurrentFile() {
        return this.currentFile;
    }

    void setCurrentFile(String s) {
        this.currentFile = s;
    }
}

