/*
 * Decompiled with CFR 0.152.
 */
package com.cudos;

import com.cudos.common.CudosExhibit;
import com.cudos.common.CustomSound;
import com.cudos.common.GraphPanel;
import com.cudos.common.HTMLMessagePane;
import com.cudos.common.SelectionRecipient;
import com.cudos.common.systems.Output;
import com.cudos.common.systems.SystemsComponent;
import com.cudos.common.systems.SystemsCustomComponent;
import com.cudos.common.systems.SystemsDiagram;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.border.Border;

public class SignalProcessingExhibit
extends CudosExhibit
implements SelectionRecipient {
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel3 = new JPanel();
    JPanel jPanel4 = new JPanel();
    JButton jButton1 = new JButton();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel jPanel5 = new JPanel();
    JPanel selectedproperties = new JPanel();
    JScrollPane componentscroll = new JScrollPane();
    BorderLayout borderLayout4 = new BorderLayout();
    BorderLayout borderLayout5 = new BorderLayout();
    JPanel sdpanel = new JPanel();
    JPanel jPanel7 = new JPanel();
    SystemsDiagram sd = new SystemsDiagram();
    BorderLayout borderLayout6 = new BorderLayout();
    Border border1;
    Border border2;
    BorderLayout borderLayout7 = new BorderLayout();
    JButton menubutton = new JButton();
    JPanel jPanel8 = new JPanel();
    JButton createcomponent = new JButton();
    JButton deletecomponent = new JButton();
    GraphPanel graphpanel = new GraphPanel();
    JPanel jPanel9 = new JPanel();
    JButton jButton2 = new JButton();
    JButton stop = new JButton();
    JPopupMenu mainpopup = new JPopupMenu();
    JMenu jMenu1 = new JMenu();
    JMenuItem menuopen = new JMenuItem();
    JMenuItem menunew = new JMenuItem();
    JMenuItem menusave = new JMenuItem();
    JMenu jMenu2 = new JMenu();
    JMenuItem menuconvert = new JMenuItem();
    JList complist = new JList<String>(componentNames);
    private static final String[] componentTypes = new String[]{"Source", "FunctionSource", "Plus", "Output", "Input", "Gain", "Integrator", "Differentiator", "SimpleTransferFunction", "FormulaTransferFunction", "Gate", "Subtract", "Multiplier", "Divider", "Delay", "LowPassFilter", "HighPassFilter"};
    private static final String[] componentNames = new String[]{"Source", "Generic source", "Signal add", "Output", "Input", "Gain", "Integrator", "Differentiator", "Simple transfer function", "Generic transfer function", "Binary gate", "Comparator", "Multiplier", "Divide", "Delay", "Low pass filter", "High pass filter"};
    Timer timer;
    SystemsComponent selection;
    BorderLayout borderLayout8;
    JMenuItem resetphases;
    JMenuItem jMenuItem1;
    JMenuItem editcomponent;
    static final String defaultFolder = "E:/Java/WebRoot/CUDOS/CLASSES/resources/SystemsComponents";
    String lastFileTransactionName;
    Vector editstack;
    JPanel jPanel6;
    JLabel infobar;
    BorderLayout borderLayout9;
    Border border3;
    JMenuItem returntoparent;
    JMenuItem soundmenu;
    JMenu jMenu3;
    JMenuItem helpcomponent;

    public String getExhibitName() {
        return "Signal Processing";
    }

    public SignalProcessingExhibit() {
        this.timer = new Timer(this.sd.timer.getDelay(), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SignalProcessingExhibit.this.sd.tick();
                SignalProcessingExhibit.this.graphpanel.tick();
            }
        });
        this.borderLayout8 = new BorderLayout();
        this.resetphases = new JMenuItem();
        this.jMenuItem1 = new JMenuItem();
        this.editcomponent = new JMenuItem();
        this.lastFileTransactionName = "File";
        this.editstack = new Vector();
        this.jPanel6 = new JPanel();
        this.infobar = new JLabel();
        this.borderLayout9 = new BorderLayout();
        this.returntoparent = new JMenuItem();
        this.soundmenu = new JMenuItem();
        this.jMenu3 = new JMenu();
        this.helpcomponent = new JMenuItem();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.componentscroll.getViewport().setView(this.complist);
        this.sd.setSelectionRecipient(this);
    }

    public void postinit() {
        this.sd.setApplet(this.getApplet());
        this.sd.postinit();
        this.menubutton.setIcon(new ImageIcon(this.getApplet().getImage("resources/icons/arrow_up.gif")));
    }

    public void setSelected(Object o) {
        if (this.selection != null) {
            this.selectedproperties.remove(this.selection.getPane());
        }
        this.editcomponent.setEnabled(false);
        if (o != null) {
            this.selection = (SystemsComponent)o;
            this.selectedproperties.add(this.selection.getPane());
            if (o instanceof SystemsCustomComponent) {
                this.editcomponent.setEnabled(true);
            }
        } else {
            this.selection = null;
        }
        this.validateTree();
        this.selectedproperties.repaint();
        this.soundmenu.setEnabled(this.selection instanceof Output);
    }

    public Object getSelected() {
        return this.selection;
    }

    public SystemsComponent createComponent(String classname) {
        SystemsComponent c = null;
        try {
            c = (SystemsComponent)Class.forName("com.cudos.common.systems." + classname).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (c != null) {
            this.sd.addComponent(c);
        }
        this.graphpanel.setComponents(this.sd.getSystemComponents());
        return c;
    }

    void replaceDiagram(SystemsDiagram d) {
        this.sdpanel.remove(this.sd);
        this.sd.setSelectionRecipient(null);
        this.sd = d;
        this.sd.setSelectionRecipient(this);
        this.sdpanel.add(this.sd);
        this.validateTree();
        this.sd.postinit();
        this.graphpanel.setComponents(this.sd.getSystemComponents());
        this.sd.setSelection(null);
        this.sd.repaint();
        System.gc();
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(134, 134, 134), new Color(93, 93, 93)), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.border2 = BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134));
        this.border3 = BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(134, 134, 134), new Color(93, 93, 93));
        this.getContentPane().setLayout(this.borderLayout1);
        this.jPanel2.setLayout(this.borderLayout2);
        this.jButton1.setText("Exit");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SignalProcessingExhibit.this.jButton1_actionPerformed(e);
            }
        });
        this.jPanel3.setLayout(this.borderLayout3);
        this.jPanel5.setLayout(this.borderLayout4);
        this.jPanel1.setLayout(this.borderLayout5);
        this.sdpanel.setLayout(this.borderLayout6);
        this.sdpanel.setBorder(this.border1);
        this.createcomponent.setPreferredSize(new Dimension(80, 27));
        this.createcomponent.setText("Create");
        this.createcomponent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SignalProcessingExhibit.this.createcomponent_actionPerformed(e);
            }
        });
        this.deletecomponent.setText("Delete");
        this.deletecomponent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SignalProcessingExhibit.this.deletecomponent_actionPerformed(e);
            }
        });
        this.graphpanel.setPreferredSize(new Dimension(250, 70));
        this.jButton2.setText("Start");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SignalProcessingExhibit.this.start(e);
            }
        });
        this.jPanel9.setPreferredSize(new Dimension(69, 100));
        this.stop.setText("Stop");
        this.stop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SignalProcessingExhibit.this.stop(e);
            }
        });
        this.jPanel7.setLayout(this.borderLayout7);
        this.componentscroll.setHorizontalScrollBarPolicy(31);
        this.componentscroll.setVerticalScrollBarPolicy(22);
        this.menubutton.setPreferredSize(new Dimension(59, 27));
        this.menubutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SignalProcessingExhibit.this.menubutton_actionPerformed(e);
            }
        });
        this.jMenu1.setMnemonic('F');
        this.jMenu1.setText("File");
        this.menuopen.setMnemonic('O');
        this.menuopen.setText("Open...");
        this.menuopen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SignalProcessingExhibit.this.menuopen_actionPerformed(e);
            }
        });
        this.menunew.setMnemonic('N');
        this.menunew.setText("New");
        this.menunew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SignalProcessingExhibit.this.menunew_actionPerformed(e);
            }
        });
        this.menusave.setMnemonic('S');
        this.menusave.setText("Save...");
        this.menusave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SignalProcessingExhibit.this.menusave_actionPerformed(e);
            }
        });
        this.jMenu2.setMnemonic('E');
        this.jMenu2.setText("Edit");
        this.menuconvert.setMnemonic('I');
        this.menuconvert.setText("Import component...");
        this.menuconvert.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SignalProcessingExhibit.this.menuconvert_actionPerformed(e);
            }
        });
        this.selectedproperties.setLayout(this.borderLayout8);
        this.resetphases.setMnemonic('R');
        this.resetphases.setText("Reset phases");
        this.resetphases.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SignalProcessingExhibit.this.resetphases_actionPerformed(e);
            }
        });
        this.jMenuItem1.setMnemonic('X');
        this.jMenuItem1.setText("Exit");
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SignalProcessingExhibit.this.jButton1_actionPerformed(e);
            }
        });
        this.editcomponent.setEnabled(false);
        this.editcomponent.setMnemonic('E');
        this.editcomponent.setText("Edit component");
        this.editcomponent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SignalProcessingExhibit.this.editcomponent_actionPerformed(e);
            }
        });
        this.infobar.setText("Ready");
        this.jPanel6.setLayout(this.borderLayout9);
        this.jPanel6.setBorder(this.border3);
        this.returntoparent.setEnabled(false);
        this.returntoparent.setMnemonic('B');
        this.returntoparent.setText("Back");
        this.returntoparent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SignalProcessingExhibit.this.returntoparent_actionPerformed(e);
            }
        });
        this.sd.setFont(new Font("SansSerif", 0, 10));
        this.soundmenu.setText("Sound");
        this.soundmenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SignalProcessingExhibit.this.soundmenu_actionPerformed(e);
            }
        });
        this.jMenu3.setText("Help");
        this.helpcomponent.setText("Component...");
        this.helpcomponent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SignalProcessingExhibit.this.helpcomponent_actionPerformed(e);
            }
        });
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.sdpanel, "Center");
        this.sdpanel.add((Component)this.sd, "Center");
        this.jPanel1.add((Component)this.jPanel7, "South");
        this.jPanel7.add((Component)this.jPanel9, "West");
        this.jPanel9.add((Component)this.menubutton, null);
        this.jPanel9.add((Component)this.jButton2, null);
        this.jPanel9.add((Component)this.stop, null);
        this.jPanel7.add((Component)this.graphpanel, "Center");
        this.jPanel7.add((Component)this.jPanel6, "South");
        this.jPanel6.add((Component)this.infobar, "Center");
        this.getContentPane().add((Component)this.jPanel2, "East");
        this.jPanel2.add((Component)this.jPanel3, "Center");
        this.jPanel3.add((Component)this.jPanel5, "Center");
        this.jPanel5.add((Component)this.componentscroll, "Center");
        this.jPanel5.add((Component)this.jPanel8, "South");
        this.jPanel8.add((Component)this.createcomponent, null);
        this.jPanel8.add((Component)this.deletecomponent, null);
        this.jPanel3.add((Component)this.selectedproperties, "South");
        this.jPanel2.add((Component)this.jPanel4, "South");
        this.jPanel4.add((Component)this.jButton1, null);
        this.mainpopup.add(this.jMenu1);
        this.mainpopup.add(this.jMenu2);
        this.mainpopup.add(this.jMenu3);
        this.jMenu1.add(this.menunew);
        this.jMenu1.add(this.menuopen);
        this.jMenu1.add(this.menusave);
        this.jMenu1.addSeparator();
        this.jMenu1.add(this.jMenuItem1);
        this.jMenu2.add(this.soundmenu);
        this.jMenu2.add(this.resetphases);
        this.jMenu2.addSeparator();
        this.jMenu2.add(this.menuconvert);
        this.jMenu2.add(this.editcomponent);
        this.jMenu2.add(this.returntoparent);
        this.jMenu3.add(this.helpcomponent);
        this.complist.setSelectionMode(0);
    }

    void jButton1_actionPerformed(ActionEvent e) {
        this.timer.stop();
        this.getApplet().toChooser();
    }

    void start(ActionEvent e) {
        this.start();
    }

    public void start() {
        this.timer.start();
    }

    void createcomponent_actionPerformed(ActionEvent e) {
        this.doCreate();
    }

    public SystemsComponent doCreate() {
        return this.createComponent(componentTypes[this.complist.getSelectedIndex()]);
    }

    void deletecomponent_actionPerformed(ActionEvent e) {
        if (this.selection != null) {
            this.removeComponent(this.selection);
        }
    }

    public void removeComponent(SystemsComponent sc) {
        this.sd.removeComponent(this.selection);
        this.graphpanel.setComponents(this.sd.getSystemComponents());
    }

    void stop(ActionEvent e) {
        this.stop();
    }

    public void stop() {
        this.timer.stop();
    }

    void menunew_actionPerformed(ActionEvent e) {
        this.filenew();
    }

    void menuconvert_actionPerformed(ActionEvent e) {
        this.importcomponent();
    }

    boolean filenew() {
        int ok = JOptionPane.showConfirmDialog(this, "This will erase the current diagram", "Confirm clear diagram", 2, 2);
        if (ok == 0) {
            this.sd.clearDiagram();
        }
        this.graphpanel.setComponents(this.sd.getSystemComponents());
        return ok == 0;
    }

    public void importcomponent() {
        try {
            SystemsCustomComponent sc;
            SystemsDiagram nsd;
            InputStream file = this.openFileDialog("Import component");
            if (file != null && (nsd = this.loadFromFile(file)) != null && (sc = (SystemsCustomComponent)this.createComponent("com.cudos.common.systems.SystemsCustomComponent")) != null) {
                if (!sc.setDiagram(nsd)) {
                    this.removeComponent(sc);
                } else {
                    sc.setType(this.lastFileTransactionName);
                    sc.postload();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.toString(), "Could not import item", 0);
        }
    }

    void menuopen_actionPerformed(ActionEvent e) {
        if (this.filenew()) {
            try {
                InputStream file = this.openFileDialog("Open Systems Diagram");
                if (file != null) {
                    SystemsDiagram nsd = this.loadFromFile(file);
                    this.replaceDiagram(nsd);
                }
            }
            catch (IOException x) {
                x.printStackTrace();
                JOptionPane.showMessageDialog(this, x.toString(), "Could not open item", 0);
            }
        }
    }

    void menusave_actionPerformed(ActionEvent e) {
        try {
            OutputStream file = this.saveFileDialog("Save Systems Diagram");
            this.saveToFile(this.sd, file);
        }
        catch (IOException x) {
            x.printStackTrace();
            JOptionPane.showMessageDialog(this, x.toString(), "Could not save diagram", 0);
        }
    }

    public void saveToFile(SystemsDiagram s, OutputStream fos) throws IOException {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(s.getSystemComponents());
            oos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public SystemsDiagram loadFromFile(InputStream fis) {
        SystemsDiagram nsd = new SystemsDiagram();
        nsd.setApplet(this.getApplet());
        try {
            ObjectInputStream ois = new ObjectInputStream(fis);
            nsd.setSystemComponents((Vector)ois.readObject());
            ois.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        nsd.initialiseComponents();
        return nsd;
    }

    void menubutton_actionPerformed(ActionEvent e) {
        Point tl = this.menubutton.getLocationOnScreen();
        Point t2 = this.getLocationOnScreen();
        tl.x -= t2.x;
        tl.y -= t2.y;
        tl.y -= this.mainpopup.getHeight();
        this.mainpopup.show(this, tl.x, tl.y);
    }

    OutputStream saveFileDialog(String title) throws IOException {
        JFileChooser chooser = new JFileChooser(new File(defaultFolder));
        chooser.setDialogTitle(title);
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal == 0) {
            this.lastFileTransactionName = chooser.getSelectedFile().getName();
            return new FileOutputStream(chooser.getSelectedFile());
        }
        return null;
    }

    InputStream openFileDialog(String title) throws IOException {
        JFileChooser chooser = new JFileChooser(new File(defaultFolder));
        chooser.setDialogTitle(title);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            this.lastFileTransactionName = chooser.getSelectedFile().getName();
            return new FileInputStream(chooser.getSelectedFile());
        }
        return null;
    }

    void resetphases_actionPerformed(ActionEvent e) {
        this.sd.resetAllPhases();
    }

    void editcomponent_actionPerformed(ActionEvent e) {
        SystemsCustomComponent scc = (SystemsCustomComponent)this.selection;
        this.editstack.add(this.sd);
        scc.getDiagram().setDiagramName(scc.getName());
        this.replaceDiagram(scc.getDiagram());
        this.infobar.setText("Editing " + this.getEditPath(this.editstack));
        this.returntoparent.setEnabled(true);
    }

    void returntoparent_actionPerformed(ActionEvent e) {
        SystemsDiagram scd = (SystemsDiagram)this.editstack.get(this.editstack.size() - 1);
        this.editstack.remove(scd);
        this.replaceDiagram(scd);
        if (this.editstack.isEmpty()) {
            this.returntoparent.setEnabled(false);
            this.infobar.setText("Ready");
        } else {
            this.infobar.setText("Editing " + this.getEditPath(this.editstack));
        }
    }

    String getEditPath(Vector v) {
        String s = "";
        int i = 0;
        while (i < v.size()) {
            s = String.valueOf(s) + "/" + ((SystemsDiagram)v.get(i)).getDiagramName();
            ++i;
        }
        return String.valueOf(s) + "/" + this.sd.getDiagramName();
    }

    void soundmenu_actionPerformed(ActionEvent e) {
        if (this.selection == null) {
            return;
        }
        final boolean t = this.timer.isRunning();
        if (t) {
            this.stop();
        }
        Thread thread = new Thread(new Runnable(){

            public void run() {
                byte[] p = new byte[22000];
                short o = 0;
                short oo = 0;
                int i = 0;
                while (i < p.length) {
                    o = (short)(6144.0 * SignalProcessingExhibit.this.selection.getOutput());
                    p[i++] = (byte)(o % 256);
                    p[i] = (byte)(o / 256);
                    SignalProcessingExhibit.this.sd.tick();
                    oo = o;
                    ++i;
                }
                CustomSound s = new CustomSound(p);
                s.playOnce();
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                s.close();
                if (t) {
                    SignalProcessingExhibit.this.start();
                }
            }
        });
        thread.start();
    }

    void helpcomponent_actionPerformed(ActionEvent e) {
        String typename = this.selection == null ? "SystemsHelp" : this.selection.getType();
        URL resource = this.getApplet().getResourceURL("resources/text/" + typename + ".html");
        HTMLMessagePane.showDialog(resource, "Help on component " + typename, this);
    }
}

