/*
 * Decompiled with CFR 0.152.
 */
package com.cudos;

import com.cudos.common.CudosApplet;
import com.cudos.common.CudosExhibit;
import com.cudos.common.TitleBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import sun.audio.AudioPlayer;
import sun.audio.AudioStream;

public class CudosApplication
extends JFrame
implements CudosApplet {
    BorderLayout borderLayout1 = new BorderLayout();
    TitleBar titleBar1 = new TitleBar();
    String[] params;
    Vector stack = new Vector();
    private CudosExhibit content;
    JPanel mainpanel = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();

    public static void main(String[] s) {
        CudosApplication app = new CudosApplication();
        app.params = s;
    }

    public CudosApplication() throws HeadlessException {
        try {
            this.jbInit();
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setSize(900, 700);
        this.init();
        this.show();
        this.setDefaultCloseOperation(2);
    }

    private void init() {
        String clsname = this.getParameter("exhibit");
        if (clsname != null) {
            int p = clsname.indexOf(58);
            if (p > 0) {
                String params = clsname.substring(p + 1);
                clsname = clsname.substring(0, p);
                this.toExhibit(clsname, params);
                return;
            }
        } else {
            clsname = "com.cudos.ModuleChooser";
        }
        this.toExhibit(clsname);
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.borderLayout1);
        this.mainpanel.setLayout(this.borderLayout2);
        this.getContentPane().add((Component)this.titleBar1, "North");
        this.getContentPane().add((Component)this.mainpanel, "Center");
    }

    public URL getResourceURL(String s) {
        URL r = this.getClass().getResource("../../" + s);
        if (r != null) {
            return r;
        }
        r = this.getClass().getResource("/" + s);
        if (r != null) {
            return r;
        }
        JOptionPane.showMessageDialog(null, "Unable to find resource " + s);
        throw new RuntimeException("Resource not found: " + s);
    }

    public Image getImage(String s) {
        Image i = null;
        try {
            URL resource = this.getResourceURL(s);
            i = Toolkit.getDefaultToolkit().createImage(resource);
        }
        catch (Exception e) {
            this.error(String.valueOf(e.toString()) + ": error loading image " + s);
        }
        if (i == null) {
            this.error("Could not find image " + s);
        }
        return i;
    }

    public String getParameter(String s) {
        if (this.params == null) {
            return null;
        }
        int i = 0;
        while (i < this.params.length) {
            String left = this.params[i].substring(0, this.params[i].indexOf(61)).trim();
            if (left.equalsIgnoreCase(s)) {
                return this.params[i].substring(this.params[i].indexOf(61) + 1).trim();
            }
            ++i;
        }
        return null;
    }

    public int getTextHeight(Graphics2D g, String s) {
        return (int)g.getFontMetrics().getStringBounds(s, g).getHeight();
    }

    public int getTextWidth(Graphics2D g, String s) {
        return (int)g.getFontMetrics().getStringBounds(s, g).getWidth();
    }

    public void paintComponentMessage(Component c, String s) {
        Graphics2D g = (Graphics2D)c.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setFont(new Font("SansSerif", 1, 16));
        this.paintText3D(g, s, (c.getWidth() - this.getTextWidth(g, s)) / 2, (c.getHeight() - this.getTextHeight(g, s)) / 2);
    }

    public void paintText3D(Graphics2D g, String t, int x, int y) {
        g.setPaint(SystemColor.controlLtHighlight);
        g.drawString(t, x + 1, y + 1);
        g.setPaint(SystemColor.controlShadow);
        g.drawString(t, x, y);
    }

    public void toChooser() {
        this.stack.remove(this.content.getClass().getName());
        String oldcls = (String)this.stack.get(this.stack.size() - 1);
        this.setExhibitContent(oldcls);
    }

    public void toExhibit(String cls) {
        try {
            this.setExhibitContent(cls);
            this.stack.add(cls);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.content, "Could not load exhibit " + cls + ": " + e);
        }
    }

    public void toExhibit(String cls, Object param) {
        try {
            this.setExhibitContent(cls, param);
            this.stack.add(cls);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.content, "Could not load exhibit " + cls + ": " + e);
        }
    }

    private void setExhibitContent(CudosExhibit e) {
        CudosExhibit newcontent = e;
        if (newcontent != null) {
            if (this.content != null) {
                this.mainpanel.remove(this.content);
            }
            this.content = newcontent;
            this.mainpanel.add((Component)this.content, "Center");
            this.validateTree();
            this.setTitle(this.content.getExhibitName());
            this.content.postinit();
            this.mainpanel.repaint();
        }
    }

    void setExhibitContent(String clsname, Object param) {
        try {
            CudosExhibit newcontent;
            Class<?> cls = Class.forName(clsname);
            if (param != null) {
                Constructor<?> cn = cls.getConstructor(param.getClass());
                newcontent = (CudosExhibit)cn.newInstance(param);
            } else {
                newcontent = (CudosExhibit)cls.newInstance();
            }
            this.setExhibitContent(newcontent);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error(e + ": could not create exhibit " + clsname + " with param " + param);
        }
    }

    public void setTitle(String s) {
        super.setTitle(s);
        this.titleBar1.setTitle(s);
        this.titleBar1.repaint();
    }

    void setExhibitContent(String clsname) {
        this.setExhibitContent(clsname, null);
    }

    public void error(String s) {
        JOptionPane.showMessageDialog(this, s, "CUDOS Application Error", 0);
    }

    public void play(URL uRL) {
        try {
            AudioPlayer.player.start((InputStream)new AudioStream(uRL.openStream()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

