/*
 * Decompiled with CFR 0.152.
 */
package com.cudos;

import com.cudos.circuit.CircuitComponent;
import com.cudos.circuit.Circuitboard;
import com.cudos.circuit.GraphComponent;
import com.cudos.common.CudosExhibit;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.Timer;

public class CircuitExhibit
extends CudosExhibit {
    static final String[] componentTypes = new String[]{"Wire", "Cell", "Resistor", "Capacitor", "Ammeter", "Voltmeter", "Lamp", "Switch", "ACSource", "Diode"};
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel3 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JButton jButton1 = new JButton();
    JPanel jPanel4 = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    JButton gobutton = new JButton();
    Circuitboard cb = new Circuitboard();
    JPanel rightpane = new JPanel();
    BorderLayout borderLayout4 = new BorderLayout();
    JPanel jPanel5 = new JPanel();
    JScrollPane jScrollPane1 = new JScrollPane();
    JList complist = new JList<String>(componentTypes);
    BorderLayout borderLayout5 = new BorderLayout();
    JToggleButton createcomp = new JToggleButton();
    JPanel selectionpane = new JPanel();
    CircuitComponent dragging = null;
    boolean dragall;
    boolean dragstart;
    int dragpos;
    ComponentRenderer crender = new ComponentRenderer();
    Image[] cims = new Image[componentTypes.length];
    CircuitComponent selectedcomponent = null;
    JPanel raillabels = new JPanel(){

        public void paint(Graphics g) {
            super.paint(g);
            g.setColor(Color.black);
            int i = 0;
            while (i < CircuitExhibit.this.cb.cw) {
                double v = CircuitExhibit.this.cb.rail[i].voltage;
                if (!Double.isNaN(v)) {
                    g.drawString(String.valueOf((double)Math.round(v * 100.0) / 100.0), i * CircuitExhibit.this.cb.sx, 30);
                }
                ++i;
            }
        }
    };
    GraphComponent graphcomp = new GraphComponent(this.cb);
    Timer timer = new Timer(100, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            CircuitExhibit.this.tick();
        }
    });
    JButton graphselect = new JButton();
    JButton millistep = new JButton();

    public String getExhibitName() {
        return "Circuitboard";
    }

    public CircuitExhibit() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.cb.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (CircuitExhibit.this.createcomp.isSelected()) {
                    CircuitComponent newc;
                    Point start = CircuitExhibit.this.cb.getNearestNode(e.getPoint());
                    if (CircuitExhibit.this.cb.isOpen(start) && (newc = CircuitExhibit.this.addCircuitComponent(CircuitExhibit.this.complist.getSelectedValue().toString(), start.y, start.x, start.x)) != null) {
                        CircuitExhibit.this.selectComponent(newc);
                        CircuitExhibit.this.dragging = newc;
                        CircuitExhibit.this.dragstart = false;
                        CircuitExhibit.this.dragall = false;
                        CircuitExhibit.this.createcomp.setSelected(false);
                    }
                } else {
                    CircuitComponent d;
                    Point node = CircuitExhibit.this.cb.getExactNode(e.getPoint());
                    if (node != null && (d = CircuitExhibit.this.cb.getComponentAtNode(node)) != null) {
                        CircuitExhibit.this.selectComponent(d);
                        CircuitExhibit.this.dragging = d;
                        CircuitExhibit.this.dragstart = d.c1 == node.x;
                        CircuitExhibit.this.dragall = false;
                    } else {
                        d = CircuitExhibit.this.cb.getComponent(e.getPoint());
                        if (d != null) {
                            CircuitExhibit.this.selectComponent(d);
                            CircuitExhibit.this.dragging = d;
                            CircuitExhibit.this.dragall = true;
                            CircuitExhibit.this.dragpos = CircuitExhibit.this.cb.getNearestNode((Point)e.getPoint()).x - d.c1;
                        } else {
                            CircuitExhibit.this.selectComponent(null);
                        }
                    }
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (CircuitExhibit.this.dragging != null && CircuitExhibit.this.dragging.c1 == CircuitExhibit.this.dragging.c2) {
                    CircuitExhibit.this.removeCircuitComponent(CircuitExhibit.this.dragging);
                }
                CircuitExhibit.this.dragging = null;
            }
        });
        this.cb.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                Point end;
                if (CircuitExhibit.this.dragging != null && (end = CircuitExhibit.this.cb.getNearestNode(e.getPoint())) != null) {
                    if (CircuitExhibit.this.dragall) {
                        if (CircuitExhibit.this.cb.isLineClear(end.x - CircuitExhibit.this.dragpos, end.x - CircuitExhibit.this.dragpos + (CircuitExhibit.this.dragging.c2 - CircuitExhibit.this.dragging.c1), end.y, CircuitExhibit.this.dragging)) {
                            int w = CircuitExhibit.this.dragging.c2 - CircuitExhibit.this.dragging.c1;
                            CircuitExhibit.this.dragging.c1 = end.x - CircuitExhibit.this.dragpos;
                            CircuitExhibit.this.dragging.c2 = CircuitExhibit.this.dragging.c1 + w;
                            CircuitExhibit.this.dragging.ch = end.y;
                            CircuitExhibit.this.dragging.onMove();
                        }
                    } else if (CircuitExhibit.this.dragstart) {
                        if (CircuitExhibit.this.cb.isLineClear(CircuitExhibit.this.dragging.c1, end.x, CircuitExhibit.this.dragging.ch, CircuitExhibit.this.dragging)) {
                            CircuitExhibit.this.dragging.c1 = end.x;
                            CircuitExhibit.this.dragging.onMove();
                        }
                    } else if (CircuitExhibit.this.cb.isLineClear(end.x, CircuitExhibit.this.dragging.c2, CircuitExhibit.this.dragging.ch, CircuitExhibit.this.dragging)) {
                        CircuitExhibit.this.dragging.c2 = end.x;
                        CircuitExhibit.this.dragging.onMove();
                    }
                }
            }
        });
        this.gobutton.doClick();
    }

    public void removeCircuitComponent(CircuitComponent comp) {
        if (comp.selected) {
            this.selectComponent(null);
        }
        this.cb.removeCircuitComponent(comp);
        this.graphcomp.reset();
    }

    public void removeAllCircuitComponents() {
        this.selectComponent(null);
        this.cb.removeAllCircuitComponents();
        this.graphcomp.reset();
    }

    public CircuitComponent addCircuitComponent(String classname, int h, int a, int b) {
        CircuitComponent newc = null;
        try {
            Class<?> cl = Class.forName("com.cudos.circuit." + classname);
            newc = (CircuitComponent)cl.getConstructor(Class.forName("com.cudos.circuit.Circuitboard")).newInstance(this.cb);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (newc != null) {
            newc.ch = h;
            newc.c1 = a;
            newc.c2 = b;
            newc.onMove();
            this.cb.addCircuitComponent(newc);
        }
        this.graphcomp.reset();
        return newc;
    }

    public void setupimages() {
        int i = 0;
        while (i < this.cims.length) {
            this.cims[i] = this.getApplet().getImage("resources/icons/" + componentTypes[i] + ".gif");
            ++i;
        }
    }

    public void selectComponent(CircuitComponent cc) {
        if (this.selectedcomponent != null) {
            this.selectionpane.remove(this.selectedcomponent);
            this.selectedcomponent.selected = false;
        }
        this.selectedcomponent = cc;
        if (cc != null) {
            this.selectionpane.add(cc);
            cc.selected = true;
        }
        this.cb.repaint();
        this.validateTree();
        this.rightpane.repaint();
    }

    public void postinit() {
        this.cb.init();
        CircuitComponent cell0 = this.addCircuitComponent("Cell", 0, 0, this.cb.cw - 1);
        this.setupimages();
        this.complist.repaint();
    }

    public void tick() {
        this.cb.startCalculation();
        this.raillabels.repaint();
        this.graphcomp.tick();
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.borderLayout1);
        this.jPanel2.setLayout(this.borderLayout2);
        this.jButton1.setText("Return");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitExhibit.this.jButton1_actionPerformed(e);
            }
        });
        this.jPanel1.setLayout(this.borderLayout3);
        this.gobutton.setText("Go");
        this.gobutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitExhibit.this.gobutton_actionPerformed(e);
            }
        });
        this.rightpane.setLayout(this.borderLayout4);
        this.rightpane.setPreferredSize(new Dimension(215, 200));
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.jScrollPane1.setPreferredSize(new Dimension(70, 200));
        this.complist.setSelectionBackground(Color.yellow);
        this.complist.setSelectionForeground(Color.black);
        this.complist.setSelectionMode(0);
        this.jPanel5.setLayout(this.borderLayout5);
        this.createcomp.setText("Add");
        this.cb.setPreferredSize(new Dimension(10, 30));
        this.raillabels.setPreferredSize(new Dimension(10, 30));
        this.graphselect.setText("Graph");
        this.graphselect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitExhibit.this.graphselect_actionPerformed(e);
            }
        });
        this.millistep.setText("Step");
        this.millistep.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitExhibit.this.millistep_actionPerformed(e);
            }
        });
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jPanel4, "South");
        this.jPanel4.add((Component)this.gobutton, null);
        this.jPanel4.add((Component)this.millistep, null);
        this.jPanel1.add((Component)this.raillabels, "North");
        this.jPanel1.add((Component)this.cb, "Center");
        this.getContentPane().add((Component)this.jPanel2, "East");
        this.jPanel2.add((Component)this.jPanel3, "South");
        this.jPanel3.add((Component)this.graphselect, null);
        this.jPanel3.add((Component)this.jButton1, null);
        this.jPanel2.add((Component)this.rightpane, "Center");
        this.rightpane.add((Component)this.jPanel5, "Center");
        this.jPanel5.add((Component)this.jScrollPane1, "Center");
        this.jPanel5.add((Component)this.createcomp, "South");
        this.rightpane.add((Component)this.selectionpane, "South");
        this.jScrollPane1.getViewport().setView(this.complist);
        this.complist.setCellRenderer(this.crender);
    }

    void jButton1_actionPerformed(ActionEvent e) {
        this.getApplet().toChooser();
    }

    void gobutton_actionPerformed(ActionEvent e) {
        if (this.gobutton.getText().equals("Go")) {
            this.timer.start();
            this.gobutton.setText("Stop");
            this.millistep.setEnabled(false);
        } else {
            this.timer.stop();
            this.gobutton.setText("Go");
            this.millistep.setEnabled(true);
        }
    }

    void graphselect_actionPerformed(ActionEvent e) {
        this.selectComponent(this.graphcomp);
    }

    void millistep_actionPerformed(ActionEvent e) {
        this.tick();
    }

    class ComponentRenderer
    extends JLabel
    implements ListCellRenderer {
        Image i;
        Point p1;
        Point p2;

        ComponentRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(componentTypes[index]);
            this.setIcon(null);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            this.i = CircuitExhibit.this.cims[index];
            this.setPreferredSize(new Dimension(CircuitExhibit.this.getApplet().getTextWidth((Graphics2D)list.getGraphics(), this.getText()) + 60, 60));
            return this;
        }

        public void paint(Graphics g_) {
            Graphics2D g = (Graphics2D)g_;
            super.paint(g_);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(this.getForeground());
            g.setStroke(new BasicStroke(3.0f));
            this.p1 = new Point(this.getWidth() / 2, this.getHeight() / 2);
            this.p2 = new Point(this.getWidth(), this.getHeight() / 2);
            int mid = (this.p1.x + this.p2.x) / 2;
            int dw = this.i.getWidth(this) / 2;
            int dh = this.i.getHeight(this) / 2;
            g.drawLine(this.p1.x, this.p1.y, mid - dw, this.p1.y);
            g.drawLine(mid + dw, this.p1.y, this.p2.x, this.p1.y);
            g.drawImage(this.i, mid - dw, this.p1.y - dh, this);
        }

        public boolean imageUpdate(Image img, int info, int x, int y, int w, int h) {
            if ((info & 0x20) != 0) {
                CircuitExhibit.this.complist.repaint();
                return false;
            }
            return true;
        }
    }
}

