/*
 * Decompiled with CFR 0.152.
 */
package com.cudos;

import com.cudos.BrownianMotion_pressure_changeAdapter;
import com.cudos.BrownianMotion_speed_changeAdapter;
import com.cudos.common.CudosExhibit;
import com.cudos.common.Oscilloscope;
import com.cudos.common.kinetic.CircularWall;
import com.cudos.common.kinetic.KineticPane;
import com.cudos.common.kinetic.MassiveMolecule;
import com.cudos.common.kinetic.Molecule;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;

public class BrownianMotion
extends CudosExhibit
implements ActionListener {
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JButton jButton1 = new JButton();
    JPanel jPanel2 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    Border border1;
    JPanel jPanel3 = new JPanel();
    Border border2;
    JPanel jPanel4 = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    Border border3;
    BorderLayout borderLayout4 = new BorderLayout();
    KineticPane kpane = new KineticPane();
    JPanel jPanel5 = new JPanel();
    JPanel jPanel6 = new JPanel();
    JSlider speed = new JSlider();
    BorderLayout borderLayout5 = new BorderLayout();
    JPanel jPanel7 = new JPanel();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    FlowLayout flowLayout1 = new FlowLayout();
    JLabel jLabel3 = new JLabel();
    JLabel jLabel4 = new JLabel();
    JLabel jLabel5 = new JLabel();
    JSlider pressure = new JSlider();
    JLabel jLabel6 = new JLabel();
    MassiveMolecule smoke;
    Oscilloscope osc = new Oscilloscope(5, this){

        public void drawScreenElements(Graphics2D g) {
            g.setColor(Color.gray);
            int u = this.getGutter();
            int i = 0;
            while (i < this.getColors().length) {
                g.drawLine(u, u + this.getBaseY()[i], this.getWidth() - 2 * u, u + this.getBaseY()[i]);
                ++i;
            }
        }
    };
    Timer timer = new Timer(300, new ActionListener(){
        int oldnc;
        int nbuck = 30;
        double topspeed = 15.0;
        int[] bucket;

        public void actionPerformed(ActionEvent e) {
            double ctot = 0.0;
            double cstot = 0.0;
            int n = 0;
            this.bucket = new int[this.nbuck];
            Enumeration mo = BrownianMotion.this.kpane.molecules.elements();
            while (mo.hasMoreElements()) {
                Molecule m = (Molecule)mo.nextElement();
                int sq = m.vx * m.vx + m.vy * m.vy;
                cstot += (double)sq;
                double speed = Math.sqrt(sq);
                ctot += speed;
                int ib = (int)(speed * (double)this.nbuck / this.topspeed);
                int n2 = BrownianMotion.this.min(ib, this.nbuck - 1);
                this.bucket[n2] = this.bucket[n2] + 1;
                ++n;
            }
            BrownianMotion.this.osc.setPosY(new int[]{-((int)(50.0 * Math.sqrt(BrownianMotion.this.smoke.vx * BrownianMotion.this.smoke.vx + BrownianMotion.this.smoke.vy * BrownianMotion.this.smoke.vy))), -((int)Math.sqrt((BrownianMotion.this.smoke.x - (double)BrownianMotion.this.smokestartx) * (BrownianMotion.this.smoke.x - (double)BrownianMotion.this.smokestartx) + (BrownianMotion.this.smoke.y - (double)BrownianMotion.this.smokestarty) * (BrownianMotion.this.smoke.y - (double)BrownianMotion.this.smokestarty))), -((int)(50.0 * ctot / (double)n)), -((int)(50.0 * Math.sqrt(cstot / (double)n))), -(5 * (BrownianMotion.this.kpane.nCollisions - this.oldnc) * 1000 / 300)});
            this.oldnc = BrownianMotion.this.kpane.nCollisions;
            JPanel h = BrownianMotion.this.histogram;
            BrownianMotion.this.histogram.paintImmediately(h.getBounds());
            Graphics2D g = (Graphics2D)h.getGraphics();
            int bl = 2;
            g.setColor(Color.green);
            g.drawLine(0, h.getHeight() - bl, h.getWidth(), h.getHeight() - bl);
            int i = 0;
            while (i < this.nbuck) {
                g.fillRect(i * h.getWidth() / this.nbuck, h.getHeight() - this.bucket[i], h.getWidth() / this.nbuck, this.bucket[i] - 2);
                ++i;
            }
        }
    });
    int smokestartx = 100;
    int smokestarty = 200;
    Random rand = new Random();
    Rectangle rect;
    JLabel jLabel7 = new JLabel();
    JPanel jPanel8 = new JPanel();
    Border border4;
    JPanel histogram = new JPanel();
    BorderLayout borderLayout6 = new BorderLayout();
    Border border5;

    public String getExhibitName() {
        return "Brownian Motion";
    }

    public BrownianMotion() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int min(int i, int j) {
        return i > j ? j : i;
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void postinit() {
        this.rect = new Rectangle(5, 5, this.kpane.getWidth() - 10, this.kpane.getHeight() / 2 - 10);
        int i = 0;
        while (i < 300) {
            Molecule m = new Molecule(this.rand, this.rect);
            this.kpane.molecules.add(m);
            m.setType(0);
            ++i;
        }
        this.smoke = new MassiveMolecule(this.smokestartx, this.smokestarty);
        this.kpane.molecules.add(this.smoke);
        this.kpane.swalls.add(new CircularWall(this.smoke, 15.0));
        this.smoke.setType(5);
        this.smoke.vx = 4.0;
        this.smoke.vy = 7.0;
        this.smoke.s = 25;
        this.smoke.Mass = 15.0;
        this.osc.setBaseY(new int[]{60, 100, 150, 180, 220});
        this.osc.setColors(new Color[]{Color.red, Color.green, Color.blue, Color.yellow, Color.cyan});
        this.osc.timer.setDelay(300);
        this.timer.start();
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.border2 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0, Color.white, new Color(255, 255, 235), new Color(94, 93, 80), new Color(135, 133, 115)), BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.border3 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, new Color(255, 255, 235), Color.white, new Color(135, 133, 115), new Color(94, 93, 80)), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.border4 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0, Color.white, Color.white, new Color(134, 134, 134), new Color(93, 93, 93)), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.border5 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, new Color(255, 255, 235), Color.white, new Color(135, 133, 115), new Color(94, 93, 80)), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.getContentPane().setLayout(this.borderLayout1);
        this.jButton1.setText("Exit");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BrownianMotion.this.jButton1_actionPerformed(e);
            }
        });
        this.jPanel2.setLayout(this.borderLayout2);
        this.jPanel2.setBorder(this.border1);
        this.jPanel3.setBorder(this.border2);
        this.jPanel3.setLayout(this.borderLayout3);
        this.jPanel4.setBorder(this.border3);
        this.jPanel4.setLayout(this.borderLayout4);
        this.kpane.setBackground(new Color(192, 224, 224));
        this.jPanel5.setPreferredSize(new Dimension(250, 10));
        this.jPanel5.setLayout(this.borderLayout5);
        this.jPanel6.setPreferredSize(new Dimension(10, 100));
        this.jLabel1.setFont(new Font("Dialog", 1, 12));
        this.jLabel1.setForeground(Color.red);
        this.jLabel1.setText("Speed");
        this.jPanel7.setBackground(Color.gray);
        this.jPanel7.setPreferredSize(new Dimension(40, 27));
        this.jPanel7.setLayout(this.flowLayout1);
        this.jLabel2.setFont(new Font("Dialog", 1, 12));
        this.jLabel2.setForeground(Color.green);
        this.jLabel2.setText("Dist");
        this.flowLayout1.setAlignment(2);
        this.flowLayout1.setHgap(0);
        this.jLabel3.setFont(new Font("Dialog", 1, 12));
        this.jLabel3.setForeground(Color.blue);
        this.jLabel3.setText("< c >");
        this.jLabel4.setText("Animation speed");
        this.speed.setPreferredSize(new Dimension(150, 24));
        this.speed.setBorder(BorderFactory.createLineBorder(SystemColor.control, 1));
        this.speed.addChangeListener(new BrownianMotion_speed_changeAdapter(this));
        this.osc.setPreferredSize(new Dimension(250, 58));
        this.jLabel5.setText("Gas pressure");
        this.pressure.setPreferredSize(new Dimension(150, 24));
        this.pressure.setBorder(BorderFactory.createLineBorder(SystemColor.control, 1));
        this.pressure.addChangeListener(new BrownianMotion_pressure_changeAdapter(this));
        this.jLabel6.setFont(new Font("Dialog", 1, 12));
        this.jLabel6.setForeground(Color.yellow);
        this.jLabel6.setText("rms");
        this.jLabel7.setFont(new Font("Dialog", 1, 12));
        this.jLabel7.setForeground(Color.cyan);
        this.jLabel7.setText("Impact");
        this.jPanel8.setBackground(SystemColor.control);
        this.jPanel8.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0, new Color(255, 255, 235), Color.white, new Color(135, 133, 115), new Color(94, 93, 80)), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.jPanel8.setPreferredSize(new Dimension(130, 60));
        this.jPanel8.setLayout(this.borderLayout6);
        this.histogram.setBackground(Color.black);
        this.histogram.setBorder(this.border5);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel1.add((Component)this.jButton1, null);
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.jPanel2.add((Component)this.jPanel3, "Center");
        this.jPanel3.add((Component)this.jPanel4, "Center");
        this.jPanel4.add((Component)this.kpane, "Center");
        this.jPanel2.add((Component)this.jPanel5, "East");
        this.jPanel5.add((Component)this.osc, "Center");
        this.osc.add((Component)this.jPanel7, "West");
        this.jPanel7.add((Component)this.jLabel1, null);
        this.jPanel7.add((Component)this.jLabel2, null);
        this.jPanel7.add((Component)this.jLabel3, null);
        this.jPanel7.add((Component)this.jLabel6, null);
        this.jPanel7.add((Component)this.jLabel7, null);
        this.jPanel2.add((Component)this.jPanel6, "South");
        this.jPanel6.add((Component)this.jLabel4, null);
        this.jPanel6.add((Component)this.speed, null);
        this.jPanel6.add((Component)this.jLabel5, null);
        this.jPanel6.add((Component)this.pressure, null);
        this.jPanel6.add((Component)this.jPanel8, null);
        this.jPanel8.add((Component)this.histogram, "Center");
    }

    void jButton1_actionPerformed(ActionEvent e) {
        this.kpane.timer.stop();
        this.getApplet().toChooser();
    }

    void speed_stateChanged(ChangeEvent e) {
        this.kpane.timer.setDelay(100 - this.speed.getValue());
    }

    void pressure_stateChanged(ChangeEvent e) {
        block3: {
            int tries;
            int targ;
            block2: {
                targ = this.pressure.getValue() * 3;
                tries = 0;
                if (this.kpane.molecules.size() <= targ) break block2;
                while (this.kpane.molecules.size() > targ && tries++ < 30) {
                    Molecule m = this.kpane.getAMolecule(this.rand, 0);
                    m.paint((Graphics2D)this.kpane.getGraphics(), false);
                    this.kpane.molecules.remove(m);
                }
                break block3;
            }
            if (this.kpane.molecules.size() >= targ) break block3;
            while (this.kpane.molecules.size() < targ && tries++ < 30) {
                Molecule m = new Molecule(this.rand, this.rect);
                this.kpane.molecules.add(m);
                m.setType(0);
            }
        }
    }
}

